import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../../util/processResponse.js";

const COUNTRY_URL = `${BASE_API_URL_STG}/countries`;

const initialState = {
    countries: [],
    loading: false,
};

export const getCountries = createAsyncThunk(
    "user/getCountries",
    async (access_token) => {
        const response = await queryResponse(COUNTRY_URL, "GET", access_token);
        return response;
    }
);

const getCountriesSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetCountry: (state) => {
            state.countries = [];
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getCountries.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getCountries.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                for (let country of records?.data) {
                    state.countries.push(country);
                }
            }
            state.loading = false;
        });
        builder.addCase(getCountries.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { resetCountry } = getCountriesSlice.actions;
export default getCountriesSlice.reducer;
